/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbcserver;

import com.mckoi.database.Database;
import com.mckoi.database.jdbcserver.ConnectionPoolServer;
import com.mckoi.database.jdbcserver.JDBCDatabaseInterface;
import com.mckoi.database.jdbcserver.MultiThreadedConnectionPoolServer;
import com.mckoi.database.jdbcserver.SingleThreadedConnectionPoolServer;
import com.mckoi.database.jdbcserver.TCPJDBCServerConnection;
import com.mckoi.debug.DebugLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public final class TCPServer {
    private Database database;
    private ConnectionPoolServer connection_pool;
    private ServerSocket server_socket;
    private InetAddress address;
    private int port;
    private String connection_pool_model;

    public TCPServer(Database database) {
        this.database = database;
    }

    public final DebugLogger Debug() {
        return this.database.Debug();
    }

    public int getJDBCPort() {
        return this.port;
    }

    public boolean checkAvailable(InetAddress bind_address, int tcp_port) {
        int port = tcp_port;
        try {
            this.server_socket = new ServerSocket(port, 50, bind_address);
            this.server_socket.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void start(InetAddress bind_address, int tcp_port, String connection_pool_model) {
        this.address = bind_address;
        this.port = tcp_port;
        this.connection_pool_model = connection_pool_model;
        if (connection_pool_model.equals("multi_threaded")) {
            this.connection_pool = new MultiThreadedConnectionPoolServer(this.database);
        } else if (connection_pool_model.equals("single_threaded")) {
            this.connection_pool = new SingleThreadedConnectionPoolServer(this.database);
        }
        try {
            this.server_socket = new ServerSocket(this.port, 50, bind_address);
            this.server_socket.setSoTimeout(0);
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            this.Debug().write(40, this, "Unable to start a server socket on port: " + this.port);
            throw new Error(e.getMessage());
        }
        Thread listen_thread = new Thread(){

            public void run() {
                try {
                    while (true) {
                        Socket s = TCPServer.this.server_socket.accept();
                        TCPServer.this.portConnection(s);
                    }
                }
                catch (IOException e) {
                    TCPServer.this.Debug().writeException(20, e);
                    TCPServer.this.Debug().write(20, this, "Socket listen thread died.");
                    return;
                }
            }
        };
        listen_thread.setName("Mckoi - TCP/IP Socket Accept");
        listen_thread.start();
    }

    private void portConnection(Socket socket) throws IOException {
        String host_string = "TCP/" + socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + "@" + socket.getLocalAddress().getHostAddress() + ":" + socket.getLocalPort();
        JDBCDatabaseInterface db_interface = new JDBCDatabaseInterface(this.database, host_string);
        TCPJDBCServerConnection connection = new TCPJDBCServerConnection(db_interface, socket, this.Debug());
        this.connection_pool.addConnection(connection);
    }

    public void close() {
        if (this.server_socket != null) {
            try {
                this.server_socket.close();
            }
            catch (IOException e) {
                this.Debug().write(40, this, "Error closing JDBC Server.");
                this.Debug().writeException(e);
            }
        }
        this.connection_pool.close();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TCP JDBC Server (");
        buf.append(this.connection_pool_model);
        buf.append(") on ");
        if (this.address != null) {
            buf.append(this.address.getHostAddress());
            buf.append(" ");
        }
        buf.append("port: ");
        buf.append(this.getJDBCPort());
        return new String(buf);
    }
}

